import { h } from 'hyperapp'

import Teacher from '../Teacher'

export default state => {
  const html = (<div class="teacher-list">
    <h2>Professeurs</h2>
    <ul>
      { state.teachers.map(teacher => {
        const teacherSubjects = state.subjects.filter(subject => subject.key === teacher.subjectKey)
        const teacherHtml = Teacher({
          picture: teacher.picture,
          lastname: teacher.lastname,
          firstname: teacher.firstname,
          subjects: teacherSubjects
        })
        return <li>{teacherHtml}</li>
      }) }
    </ul>
  </div>)
  return html
}
