import { h } from 'hyperapp'

import SubjectCategory from '../SubjectCategory'

export default (state) => (<div class="subject-list">
  <h2>Matières</h2>
  {state.subject_categories.map(category => SubjectCategory({
    title: category.title,
    subjects: state.subjects.filter(subject => subject.categoryKey === category.key).map(subject => {
      const teacher = state.teachers.find(item => item.subjectKey === subject.key)
      return {
        duration: subject.duration + ' h',
        title: subject.title,
        year: 'IMAC ' + subject.year,
        description: subject.description,
        teacher: teacher ? teacher.lastname + ' ' + teacher.firstname : 'Aucun professeur assigné'
      }
    })
  }))}
</div>)
